<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function emails()
    {
        return $this->belongsToMany('App\Models\Newletter\Email');
    }

    public function automatisms()
    {
        return $this->belongsToMany('App\Models\Newletter\Automatism');
    }

    public function metagroup()
    {
        return $this->belongsTo('App\Models\Newletter\Metagroup');
    }

}